<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common">
	<!-- Creates package-summary.html -->
	<xsl:template name="packagedoc">
		
		<xsl:variable name="packagesNodeSet" select="ancestor::Package"/>
		
		<xsl:variable name="parentPackageName">
			<xsl:for-each select="$packagesNodeSet">
				<xsl:if test="position()=last()">
					<xsl:value-of select="@name"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<xsl:variable name="parentPackageQualifiedName">
			<xsl:for-each select="$packagesNodeSet">
				<xsl:value-of select="@name"/>
				<xsl:if test="not(position()=last())">.</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<xsl:variable name="parentPackagePath">
			<xsl:for-each select="$packagesNodeSet">
				<xsl:value-of select="@name"/>
				<xsl:if test="not(position()=last())">/</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<xsl:variable name="qualifiedName">
			<xsl:choose> 
				<xsl:when test="name()='Model'"><xsl:value-of select="@name"/></xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="string-length($parentPackageQualifiedName)=0">
							<xsl:value-of select="@name"/>
						</xsl:when>
						<xsl:otherwise> 
							<xsl:value-of select="concat($parentPackageQualifiedName, '.', @name)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose> 
		</xsl:variable>

		<xsl:variable name="relPath"> 
			<xsl:choose> 
				<xsl:when test="name()='Model'">
					<xsl:value-of select="''"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="string-length($parentPackagePath) &gt; 0">
							<xsl:value-of select="concat($parentPackagePath, '/', @name)"/>
						</xsl:when>
						<xsl:otherwise> 
							<xsl:value-of select="@name"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose> 
		</xsl:variable>

		<xsl:variable name="createPath">
			<xsl:choose> 
				<xsl:when test="name()='Model'">
					<xsl:value-of select="$outdir"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($outdir, '/', $relPath)"/>
				</xsl:otherwise>
			</xsl:choose> 
		</xsl:variable>
		
		<xsl:if test="$tree_param">
			<xsl:variable name="prevPrefix">
				<xsl:call-template name="SetFilePrefix">
					<xsl:with-param name="path" select="concat($createPath, '/package-tree.html')"/>
				</xsl:call-template>
			</xsl:variable>
			
			<exsl:document href="file:///{$createPath}/package-tree.html">
				<xsl:call-template name="PackageTree">
					<xsl:with-param name="package" select="current()"></xsl:with-param>
				</xsl:call-template>
			</exsl:document>
			<xsl:variable name="tmp">
				<xsl:call-template name="ResetPrefix">
					<xsl:with-param name="prefix" select="$prevPrefix"/>
				</xsl:call-template>
			</xsl:variable>
			
		</xsl:if>

		<xsl:variable name="prevPrefix2">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($createPath, '/package-summary.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$createPath}/package-summary.html">
		<xsl:variable name="currPref">
			<xsl:call-template name="GetCurrentPrefix"/>
		</xsl:variable>
		<xsl:variable name="fullPath">
			<xsl:value-of select="concat($currPref, $relPath)"></xsl:value-of>
		</xsl:variable>
			<html>
			<head>
			<xsl:call-template name="ImportCSS"/>
			<title>
			<xsl:value-of select="$title_param"></xsl:value-of>
			</title>
			<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			<xsl:call-template name="ImgLoaderScript"/>
			</head>

			<!-- NAVBAR -->
			<xsl:if test="$navbar_param">
				<xsl:call-template name="PackageNavBar">
					<xsl:with-param name="package" select="current()"></xsl:with-param>
					<xsl:with-param name="header" select="'true'"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<hr/>

			<h2>
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code">
						<xsl:choose>
							<xsl:when test="local-name(current())='Model'">
								<xsl:value-of select="'Project'"></xsl:value-of>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'Package'"></xsl:value-of>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
					<xsl:with-param name="p1" select="$qualifiedName"></xsl:with-param>
				</xsl:call-template>
			</h2>

			<xsl:if test="boolean(string($parentPackageQualifiedName))">
			<p>
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'PPackage'"></xsl:with-param>
				</xsl:call-template>
				<xsl:apply-templates select="(ancestor::Package)[position()=last()]" mode="HRefWithImgLoad">
					<xsl:with-param name="isName" select="'1'"/>
				</xsl:apply-templates>
			</p>
			</xsl:if>	
			
			<!-- Print Namespace properties -->
			<p/>
			<hr/>
			<xsl:call-template name="printProperties">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
				<xsl:with-param name="nodeset" select="Property"></xsl:with-param>
				<xsl:with-param name="property-names" select="Property/@name"></xsl:with-param>			
			</xsl:call-template>
			<hr/>
			<p/>
				
			<!-- Create summary table for interfaces and classes (see class_util.xsl) -->
			<xsl:variable name="interfaces" select="Classifier[@type='Interface'] | Classifier//Classifier[@type='Interface'] | DesignElement//Classifier[@type='Interface']"/>
			<xsl:variable name="classes" select="Classifier[@type='Class'] | Classifier//Classifier[@type='Class'] | DesignElement//Classifier[@type='Class']"/>
			<xsl:variable name="structs" select="Classifier[@type='Struct'] | Classifier//Classifier[@type='Struct']"/>
			<xsl:variable name="enums" select="Classifier[@type='Enum'] | Classifier//Classifier[@type='Enum']"/>
			<xsl:variable name="delegates" select="Classifier[@type='Delegate'] | Classifier//Classifier[@type='Delegate']"/>
			<xsl:variable name="modules" select="Classifier[@type='Module'] | Classifier//Classifier[@type='Module']"/>
			<xsl:variable name="packages" select="Package"/>
			
			<xsl:if test="not(count($packages)=0)" >
				<xsl:variable name="packs">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'packages'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>				
			
				<xsl:call-template name="createSummaryTable">
					<xsl:with-param name="title" select="$packs"/>
					<xsl:with-param name="nodeSet" select="$packages"/>
				</xsl:call-template>
			</xsl:if>
			
			<xsl:if test="not(count($interfaces)=0)">
				<xsl:variable name="InterfaceSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Interface_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createSummaryTable">
					<xsl:with-param name="title" select="$InterfaceSummary"/>
					<xsl:with-param name="nodeSet" select="$interfaces"/>
					<xsl:with-param name="packagePath" select="$fullPath"/>
					<xsl:with-param name="italikStyle" select="'true'"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="not(count($classes)=0)">
				<xsl:variable name="ClassSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Class_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createSummaryTable">
					<xsl:with-param name="title" select="$ClassSummary"/>
					<xsl:with-param name="nodeSet" select="$classes"/>
					<xsl:with-param name="packagePath" select="$fullPath"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="not(count($structs)=0)">
				<xsl:variable name="StructSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Struct_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createSummaryTable">
					<xsl:with-param name="title" select="$StructSummary"/>
					<xsl:with-param name="nodeSet" select="$structs"/>
					<xsl:with-param name="packagePath" select="$fullPath"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="not(count($enums)=0)">
				<xsl:variable name="EnumSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Enum_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createSummaryTable">
					<xsl:with-param name="title" select="$EnumSummary"/>
					<xsl:with-param name="nodeSet" select="$enums"/>
					<xsl:with-param name="packagePath" select="$fullPath"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="not(count($delegates)=0)">
				<xsl:variable name="DelegateSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Delegate_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createSummaryTable">
					<xsl:with-param name="title" select="$DelegateSummary"/>
					<xsl:with-param name="nodeSet" select="$delegates"/>
					<xsl:with-param name="packagePath" select="$fullPath"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="not(count($modules)=0)">
				<xsl:variable name="ModuleSummary">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'Module_Summary'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="createSummaryTable">
					<xsl:with-param name="title" select="$ModuleSummary"/>
					<xsl:with-param name="nodeSet" select="$modules"/>
					<xsl:with-param name="packagePath" select="$fullPath"/>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Call classdoc template (from class.xsl) -->
			<xsl:for-each select="$classes | $interfaces | $structs | $enums | $delegates | $modules">
				<xsl:call-template name="classdoc">
					<xsl:with-param name="packageName" select="@name"/>
					<xsl:with-param name="packageQualifiedName" select="$qualifiedName"/>
					<xsl:with-param name="packagePath" select="$relPath"/>
				</xsl:call-template>

				<!-- Generate Class Usages if needed -->
				<xsl:if test="$use_param">
				
					<xsl:variable name="classifierShortName">
						<xsl:call-template name="classifierShortName">
							<xsl:with-param name="class" select="current()"></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					
					<xsl:variable name="prevPrefix">
						<xsl:call-template name="SetFilePrefix">
							<xsl:with-param name="path" select="concat($outdir, '/', $relPath, '/class-use/', $classifierShortName, '.html')"/>
						</xsl:call-template>
					</xsl:variable>
					
					<exsl:document href="file:///{$outdir}/{$relPath}/class-use/{$classifierShortName}.html">
						<xsl:call-template name="ClassUse">
							<xsl:with-param name="class" select="current()"></xsl:with-param>
						</xsl:call-template>
					</exsl:document>
					<xsl:variable name="tmp">
						<xsl:call-template name="ResetPrefix">
							<xsl:with-param name="prefix" select="$prevPrefix"/>
						</xsl:call-template>
					</xsl:variable>
					
				</xsl:if>
			</xsl:for-each>

			<!-- Create summary table for all diagrams in current package (see design_util.xsl) -->
			<!-- Split diagrams by metaclass -->
			<xsl:call-template name="diagramSummary">
				<xsl:with-param name="package" select="current()"></xsl:with-param>
				<xsl:with-param name="nodeset" select="Diagram"></xsl:with-param>
				<xsl:with-param name="metaclasses" select="Diagram/@metaclass"></xsl:with-param>			
				<xsl:with-param name="packagePath" select="$fullPath"/>
			</xsl:call-template>			
			
			<xsl:variable name="diagrams" select="Diagram"/>
			<xsl:variable name="package" select="current()"></xsl:variable>
			<xsl:for-each select="$diagrams">
				<xsl:call-template name="diagramdoc">
					<xsl:with-param name="package" select="$package"></xsl:with-param>
					<xsl:with-param name="packagePath" select="$relPath"/>
				</xsl:call-template>
			</xsl:for-each>
			
			<!-- AEIP -->
			<xsl:if test="$viewType='model'">
				<xsl:call-template name="packageElementsSummary">
					<xsl:with-param name="nodeSet" select="DesignElement"/>
					<xsl:with-param name="metaclasses" select="DesignElement/@metaclass"/>
				</xsl:call-template>
				
				<xsl:variable name="detailTitle">
					<xsl:call-template name="getLocalizedResource"><xsl:with-param name="code" select="'package_elements_detail'"/></xsl:call-template>
				</xsl:variable>
			
				<!-- Print Elements Detail {design_util.xsl}-->
				<xsl:call-template name="packageElementsDetail">
					<xsl:with-param name="title" select="$detailTitle"></xsl:with-param>
					<xsl:with-param name="nodeSet" select="//DesignElement"></xsl:with-param>
				</xsl:call-template>			
			</xsl:if>
			<!-- AEIP -->
			
			<!-- Print Element Links-->
			<xsl:call-template name="printLinks">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
				<xsl:with-param name="nodeset" select="current()/Link"></xsl:with-param>
				<xsl:with-param name="metaclasses" select="current()/Link/@metaclass"></xsl:with-param>			
			</xsl:call-template>					

			<!-- Print Element HyperLinks-->
			<xsl:call-template name="printHyperLinks">
				<xsl:with-param name="element" select="current()"></xsl:with-param>
			</xsl:call-template>					
			
			<!-- NAVBAR -->
			<hr/>
			<xsl:if test="$navbar_param">
				<xsl:call-template name="PackageNavBar">
					<xsl:with-param name="package" select="current()"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<br/>
			<p/>
			<xsl:value-of select="$bottom_param"></xsl:value-of>
			</html>
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix2"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:apply-templates/>
	</xsl:template>
	
	
	<xsl:template name="diagramSummary">
		<xsl:param name="package"></xsl:param>
		<xsl:param name="nodeset"></xsl:param>
		<xsl:param name="metaclasses"></xsl:param>
		<xsl:param name="packagePath"></xsl:param>
	
		<xsl:variable name="first" select="$metaclasses[1]"></xsl:variable>
		<xsl:if test="$first">
		<xsl:variable name="shapeType" select="string($first)"></xsl:variable>

		<xsl:variable name="codeSummary">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'summary'"/>
				<xsl:with-param name="p1" select="$shapeType"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>

		<xsl:call-template name="createDiagramSummaryTable">
				<xsl:with-param name="title" select="$codeSummary"/>
				<xsl:with-param name="nodeSet" select="$package/Diagram[@metaclass=$shapeType]"/>
				<xsl:with-param name="packagePath" select="$packagePath"/>
		</xsl:call-template>

		<xsl:call-template name="diagramSummary">
			<xsl:with-param name="package" select="$package"></xsl:with-param>
			<xsl:with-param name="nodeset" select="$nodeset"></xsl:with-param>
			<xsl:with-param name="metaclasses" select="$metaclasses[not(string($shapeType)=string(.))]"></xsl:with-param>
			<xsl:with-param name="packagePath" select="$packagePath"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template>
	
</xsl:stylesheet>
